clc;
close all;
%% Load 10 real coarse crackles here 
load RC1
load RC2
load RC3
load RC4
load RC5
load RC6
load RC7
load RC8
load RC9
load RC10
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
RC1             = [zeros(1,1000),RC1,zeros(1,Signal_length-(1000+length(RC1)))];
RC2             = [zeros(1,3000),RC2,zeros(1,Signal_length-(3000+length(RC2)))];
RC3             = [zeros(1,7000),RC3,zeros(1,Signal_length-(7000+length(RC3)))];
RC4             = [zeros(1,12000),RC4,zeros(1,Signal_length-(12000+length(RC4)))];
RC5             = [zeros(1,14000),RC5,zeros(1,Signal_length-(14000+length(RC5)))];
RC6             = [zeros(1,17000),RC6,zeros(1,Signal_length-(17000+length(RC6)))];
RC7             = [zeros(1,20000),RC7,zeros(1,Signal_length-(20000+length(RC7)))];
RC8             = [zeros(1,23000),RC8,zeros(1,Signal_length-(23000+length(RC8)))];
RC9             = [zeros(1,27500),RC9,zeros(1,Signal_length-(27500+length(RC9)))];
RC10            = [zeros(1,30000),RC10,zeros(1,Signal_length-(30000+length(RC10)))];
Ten_real_coarse_crackles        =RC1+RC2+RC3+RC4+RC5+RC6+RC7+RC8+RC9+RC10;
Ten_real_coarse_crackles        =Ten_real_coarse_crackles(1:end);
%% Plot
figure
plot(Ten_real_coarse_crackles,'k');
xlabel('Number of samples','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
%%
text(1150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(1150,.45,'RC1','fontsize',8,'FontWeight','bold')
text(3150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(3150,.45,'RC2','fontsize',8,'FontWeight','bold')
text(7150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(7150,.45,'RC3','fontsize',8,'FontWeight','bold')
text(12150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(12150,.45,'RC4','fontsize',8,'FontWeight','bold')
text(14150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(14150,.45,'RC5','fontsize',8,'FontWeight','bold')
text(17150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(17150,.45,'RC6','fontsize',8,'FontWeight','bold')
text(20150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(20150,.45,'RC7','fontsize',8,'FontWeight','bold')
text(23150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(23150,.45,'RC8','fontsize',8,'FontWeight','bold')
text(27650,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(27650,.45,'RC9','fontsize',8,'FontWeight','bold')
text(30150,.4,'\downarrow','fontsize',12,'FontWeight','bold')
text(30150,.45,'RC10','fontsize',8,'FontWeight','bold')
%%
set(gcf, 'Position',  [100, 300, 800, 300])
title('10 real coarse crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylim([-.5 .5]);
xlim([0 Signal_length]);
